<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Spatie\Permission\Models\Role;

class RegisteredUserController extends Controller
{
    public function create()
    {
        // ambil semua role yang bisa dipilih admin
        $roles = ['admin', 'penagihan', 'teknisi'];
        return view('auth.register', compact('roles'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
            'role' => ['required', 'in:admin,penagihan,teknisi'],
        ]);

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
        ]);

        // Assign role ke user baru
        $user->assignRole($request->role);

        // **JANGAN login ke user baru**
        // Auth::login($user); <-- jangan dipakai

        // Redirect balik ke halaman admin, misal ke daftar user
        return redirect()->route('users.index')
            ->with('success', 'User berhasil didaftarkan!');
    }
}