<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use DB;

class AdminDashboardController extends Controller
{
    public function index()
    {
        $bulanIni = Carbon::now()->format('Y-m'); // e.g. "2025-09"

        // Total pelanggan aktif
        $totalAktif = DB::table('pelanggans')->where('status', 'aktif')->count();

        // Total pelanggan suspend
        $totalSuspend = DB::table('pelanggans')->where('status', 'suspend')->count();

        // Total tagihan bulan ini
        $totalTagihanBulanIni = DB::table('pembayarans')
            ->where('periode', $bulanIni)
            ->sum('jumlah_tagihan');

        // Total tagihan sudah dibayar bulan ini
        $totalDibayarBulanIni = DB::table('pembayarans')
            ->where('periode', $bulanIni)
            ->sum('jumlah_dibayar');

        // Total tagihan belum dibayar (akumulasi semua bulan)
        $totalBelumDibayar = DB::table('pembayarans')
            ->whereColumn('jumlah_dibayar', '<', 'jumlah_tagihan')
            ->sum(DB::raw('jumlah_tagihan - jumlah_dibayar'));

        // Total tagihan belum dibayar pelanggan suspend
        $totalBelumDibayarSuspend = DB::table('pembayarans')
            ->join('pelanggans', 'pembayarans.pelanggan_id', '=', 'pelanggans.id')
            ->where('pelanggans.status', 'suspend')
            ->whereColumn('pembayarans.jumlah_dibayar', '<', 'pembayarans.jumlah_tagihan')
            ->sum(DB::raw('pembayarans.jumlah_tagihan - pembayarans.jumlah_dibayar'));

     // Upah teknisi pemasangan bulan ini (PSBL-)
     $upahPemasangan = DB::table('jadwal_teknisi_user')
     ->join('jadwal_teknisis', 'jadwal_teknisi_user.jadwal_teknisi_id', '=', 'jadwal_teknisis.id')
     ->where('jadwal_teknisis.no_tiket', 'LIKE', 'PSBL-%')
     ->where('jadwal_teknisi_user.nominal_upah', '>', 0)
     ->where('jadwal_teknisis.tanggal', 'like', $bulanIni.'%')
     ->sum('jadwal_teknisi_user.nominal_upah');

 // Upah teknisi mainten bulan ini (MPL-)
 $upahMainten = DB::table('jadwal_teknisi_user')
     ->join('jadwal_teknisis', 'jadwal_teknisi_user.jadwal_teknisi_id', '=', 'jadwal_teknisis.id')
     ->where('jadwal_teknisis.no_tiket', 'LIKE', 'MPL-%')
     ->where('jadwal_teknisi_user.nominal_upah', '>', 0)
     ->where('jadwal_teknisis.tanggal', 'like', $bulanIni.'%')
     ->sum('jadwal_teknisi_user.nominal_upah');

 $totalUpahTeknisi = $upahPemasangan + $upahMainten;

 $pelangganSuspend = \DB::table('pelanggans')
 ->leftJoin('grubs', 'pelanggans.grub_id', '=', 'grubs.id')
 ->where('pelanggans.status', 'suspend')
 ->select('pelanggans.*', 'grubs.nama_grub')
 ->get();

        return view('dashboard.admin', compact(
            'totalAktif',
            'totalSuspend',
            'totalTagihanBulanIni',
            'totalDibayarBulanIni',
            'totalBelumDibayar',
            'totalBelumDibayarSuspend',
            'upahPemasangan',
            'upahMainten',
            'totalUpahTeknisi',
            'pelangganSuspend'
        ));
    }
}